string GetDescription()
{
	return "Creates a randomized modern song structure with verses and choruses.\nCreates optional intro and a bridge.";
}

void GenerateStructure(Song@ s)
{
	int intro_mode = RndInt(0,4);
	// 0 = no intro
	// 1 = intro based on verse ( no voice )
	// 2 = intro based on chorus ( no voice )
	// 3 = intro based on new part, harmony and structure like verse 
	// 4 = intro based on new part, harmony and structure like chorus
	
	int start_with = RndInt(-2,1);
	// 0 - verse
	// 1 - chorus
	if (start_with < 0) start_with = 0;
	if (intro_mode == 1) start_with = 1;
	if (intro_mode == 2) start_with = 0;
	
	int bridge_mode = RndInt(0,2);
	// bridge based on
	// 0 - based on verse
	// 1 - based on chorus
	// 1 - based on new
	
	int after_bridge = RndInt(0,1);
	// 0 - verse
	// 1 - chorus
	
	int u_parts = 3;
	int bridge = 2;
	int verse = 0;
	int chorus = 1;
	if (intro_mode > 2) 
	{
		verse++;
		chorus++;
		bridge++;
		u_parts++;
	}
			
	s.SetUniqueParts(u_parts);
	
	int metrum = 4;
	if (RndInt(0,5) == 0) 
	{
		int m = RndInt(0,3);
		if (m == 0) metrum = 2;
		if (m == 1) metrum = 3;
		if (m == 2) metrum = 4;
		if (m == 3) metrum = 5;
		if (m == 3) metrum = 6;
	}
	
	// initialize unique parts
	for (int i = 0; i < u_parts; i++)
		s.GetUniquePart(i).SetMetrum(metrum);	
	
	// set unique parts (intro)
	if (intro_mode == 3) 
	{
		s.GetUniquePart(0).SetScriptStructure(s.GetUniquePart(1).GetScriptStructure());
		s.GetUniquePart(0).SetScriptStructureSeed(s.GetUniquePart(1).GetScriptStructureSeed());
	}
	else if (intro_mode == 4) 
	{
		s.GetUniquePart(0).SetScriptStructure(s.GetUniquePart(2).GetScriptStructure());
		s.GetUniquePart(0).SetScriptStructureSeed(s.GetUniquePart(2).GetScriptStructureSeed());
	}
	
	// set unique parts (bridge)
	if (bridge_mode == 0)
	{
		s.GetUniquePart(bridge).SetScriptStructure(s.GetUniquePart(verse).GetScriptStructure());
		s.GetUniquePart(bridge).SetScriptStructureSeed(s.GetUniquePart(verse).GetScriptStructureSeed());
	}
	else if (bridge_mode == 1)
	{
		s.GetUniquePart(bridge).SetScriptStructure(s.GetUniquePart(chorus).GetScriptStructure());
		s.GetUniquePart(bridge).SetScriptStructureSeed(s.GetUniquePart(chorus).GetScriptStructureSeed());
	}
	
	// count normal parts
	int parts = 7; // 2 x Verse, 4 x Chorus and 1 x Bridge
	if (intro_mode > 0) parts++;
	if (start_with > 0) parts++;
	if (after_bridge == 0) parts++;
	
	int mangle_ending = RndInt(0,1);
	if (mangle_ending > 0) parts++;
		
	string scale = GetRandomScale();
	int trans = RndInt(0,11);
	
	s.SetParts(parts);
	
	for (int i = 0; i < parts; i++)
	{
		s.GetPart(i).SetTempoMod(1.0);
		s.GetPart(i).SetScale(scale);
		s.GetPart(i).SetTranspose(trans);
	}
	
	// link the structure (intro)
	int part = 0;
	
	if (intro_mode == 1) // intro from verse
	{
		s.GetPart(0).SetUniquePart(0);
		s.GetPart(0).SetArrHint(0);
		part++;
	}
	else if (intro_mode == 2) // intro from chorus
	{
		s.GetPart(0).SetUniquePart(1);
		s.GetPart(0).SetArrHint(0);
		part++;
	}
	else if (intro_mode > 2) // intro from new 
	{
		s.GetPart(0).SetUniquePart(0);
		s.GetPart(0).SetArrHint(RndInt(0,3));
		part++;
	}
	
	// link the structure (verses)
	int first_verse = part;
	if (start_with > 0) first_verse++;
	for (int i = 0; i < 2; i++)
	{
		s.GetPart(first_verse+(i*2)).SetUniquePart(verse);
		s.GetPart(first_verse+(i*2)).SetArrHint(1);
	}
	
	if (after_bridge == 0) 
	{
		s.GetPart(first_verse+5).SetUniquePart(verse);
		s.GetPart(first_verse+5).SetArrHint(1);
	}
	
	// link the structure (bridge)
	s.GetPart(first_verse+4).SetUniquePart(bridge);
	s.GetPart(first_verse+4).SetArrHint(3);
	s.GetPart(first_verse+4).SetTranspose((trans+5)%12);
	s.GetPart(first_verse+4).SetScale(GetRandomScale());
	
	// link the structure (chorus)
	if (start_with > 0)
	{
		s.GetPart(part).SetUniquePart(chorus);
		s.GetPart(part).SetArrHint(3);	
	}
	
	for (int i = 0; i < 2; i++)
	{
		s.GetPart(first_verse+(i*2)+1).SetUniquePart(chorus);
		s.GetPart(first_verse+(i*2)+1).SetArrHint(3);
	}
	
	if (after_bridge == 0) first_verse++;	
	
	s.GetPart(first_verse+5).SetUniquePart(chorus);
	s.GetPart(first_verse+5).SetArrHint(3);
	
	s.GetPart(first_verse+6).SetUniquePart(chorus);
	s.GetPart(first_verse+6).SetArrHint(3);
	
	if (mangle_ending > 0)
	{
		trans = (trans + RndInt(1,3))%12;
		s.GetPart(first_verse+7).SetUniquePart(chorus);
		s.GetPart(first_verse+7).SetArrHint(3);
		s.GetPart(first_verse+7).SetTranspose(trans);
		s.GetPart(first_verse+6).SetTranspose(trans);
	}	
		
}